//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
// Poniszy blok ifdef to standardowa metoda tworzenia makr, ktra znacznie uatwia  
// eksport bibliotek DLL. Wszystkie pliki w tej bibliotece DLL s kompilowane z uyciem
// symbolu UNMANAGED_EXPORTS zdefiniowanego w wierszu polece. Ten symbol nie powinien by
// definiowany w adnym projekcie wykorzustujcym ten DLL. W ten sposb dowolny inny projekt,
// ktrego pliki rdowe obejmuj ten plik, bdzie traktowa funkcje UNMANAGED_API jako
// zaimportowane z biblioteki, podczas gdy ta biblioteka potraktuje symbole zdefiniowane
// w tym makro jako wyeksportowane.
#ifdef UNMANAGED_EXPORTS
#define UNMANAGED_API __declspec(dllexport)
#else
#define UNMANAGED_API __declspec(dllimport)
#endif

extern "C"
{

typedef struct _StructStringRef
{
	wchar_t *a;
	char *b;
} StructStringRef;

typedef struct _TestStruct
{
    unsigned char a;
    short b;
    int c;
    unsigned char d;
    short e;
    int f;
} TestStruct;

typedef struct _complex
{
	float re;
	float im;
} complex;
UNMANAGED_API int AddInteger(int a, int b);

UNMANAGED_API unsigned char ByteFunc(unsigned char a);
UNMANAGED_API short ShortFunc(short a);
UNMANAGED_API unsigned short WordFunc(unsigned short a);
UNMANAGED_API unsigned int UintFunc(unsigned int a);
UNMANAGED_API long LongFunc(long a);
UNMANAGED_API unsigned long UnsignedLongFunc(unsigned long a);
UNMANAGED_API char CharFunc(char a);
UNMANAGED_API float FloatFunc(float a);
UNMANAGED_API double DoubleFunc(double a);

UNMANAGED_API void ByteOutOutFunc(unsigned char a, unsigned char* o);
UNMANAGED_API void ShortOutFunc(short a, short *o);
UNMANAGED_API void WordOutFunc(unsigned short a, unsigned short *o);
UNMANAGED_API void UintOutFunc(unsigned int a, unsigned int *o);
UNMANAGED_API void IntOutFunc(int a, int *o);
UNMANAGED_API void LongOutFunc(long a, long *o);
UNMANAGED_API void UnsignedLongOutFunc(unsigned long a, unsigned long *o);
UNMANAGED_API void CharOutFunc(char a, char *o);
UNMANAGED_API void FloatOutFunc(float a, float *o);
UNMANAGED_API void DoubleOutFunc(double a, double *o);

UNMANAGED_API int StringLength(char * str);
UNMANAGED_API int UnicodeStringLength(wchar_t * str);
UNMANAGED_API char * ConcatString(char *a, char *b);
UNMANAGED_API wchar_t * ConcatUnicodeString(wchar_t *a, wchar_t *b);

UNMANAGED_API void ConcatOutString(char* a, char* b, char * o);
UNMANAGED_API void TestStructStringRef(StructStringRef a);

UNMANAGED_API void TestStructFunction(TestStruct *s);
UNMANAGED_API complex ComplexAdd(complex a, complex b);

UNMANAGED_API int IntArrayFunction(int *pia, int length);
UNMANAGED_API float FloatArrayFunction(float *pfa, int length);
UNMANAGED_API int StringArrayFunction(char **psa, int length);

UNMANAGED_API void MatrixMultiplyFunction(int *a, int *b, int *c, int x, int y, int z);
UNMANAGED_API complex ComplexAverage(complex* a, int length);

};
